
/************* OPTIMIZATION ROUTINES  ******************************
The following are GAUSS versions of the optimization routines in
"Numerical Recipes" written by Bo Honore and Ekaterini Kyriazidou
of Northwestern University, with support from an NSF grant.
You are welcome to use and distribute them as long as you

include proper attribution to the authors.
You should know that you use the routines at your own risk.
THE ROUTINES FOLLOW:

***********************************************************/

PROC (4) = AMOEBA(p,ftol,maxsec,maxit,&fct,prnum);

/* This procedure minimizes a function called FCT using the simplex
   method. The procedure is tailored after AMOEBA in Numerical Recipes.
   We are minimizing over an NDIM-dimensional vector of parameters.
   Input is a matrix P, whose NDIM+1 rows are NDIM-dimensional vectors
   which are the vertices of the starting simplex.
   FTOL is the fractional convergence tolerance to be achieved in the function
   value.
   ALP, BET, GAM below, are parameters which define the expansions and
   contractions.

   INPUT

   p      ((ndim+1) x ndim)   starting simplex
   maxsec (1x1)               maximum number of seconds allowed
   maxit  (1x1)               maximum number of iteraions allowed
   ftol   (1x1)               fractional convergence tolerance
   fct    proc                function we want to minimize
   prnum (1x1)          print every prnnum iterations @ JBJ 5/11/98  @

   OUTPUT

   p      ((ndim+1) x ndim)   final simplex; first row is the minimizing
                  vector
   y      ((ndim+1) x 1)      vector of values of fct at final simplex;
                              first number is the value of the function at
                              the minimum
   iter   (1x1)               number of iterations taken
   tim    (1x1)               number of seconds of running time

   While running the following are printed on the screen:
   the number of the current iteration and of seconds of running time,
   the value of the function at the current simplex (transposed), and
   the current simplex (transposed).
   In the end the following are printed on the screen:
   the number of the final iteration, the number of seconds taken,
   the value of the function at the final simplex (transposed); the
   first number is the value of the function at the minimum
   the final simplex (transposed); first column is the minimizing vector.
*/

     local y,j,date1,tim,ndim,npts,pr,prr,pbar,ind,ihi,inhi,ilo,rtol,
       alp,bet,gam,ypr,yprr,i,iter,fct:proc   ;

     tim=0;
     date1=date;
     alp=1.; bet=0.5; gam=2.0;
     ndim=cols(p);
     npts=ndim+1;
     y=zeros(ndim+1,1);
     j=1;
       do while j<=npts;
       y[j,1]=fct(p[j,.]');
       j=j+1;
       endo;


     iter=0;
     begy:
      tim=ethsec(date1,date)/100;
      ind=sortind(y);
      ihi=ind[npts,1];
      inhi=ind[npts-1,1];
      ilo=ind[1,1];
      if (abs(y[ihi,1]+y[ilo,1]) > 1e-15);  /*  Added -8-4-96 (JBJ) */
        rtol=2.*abs(y[ihi,1]-y[ilo,1])/abs(y[ihi,1]+y[ilo,1]);
        else; rtol=2.*abs(y[ihi,1]-y[ilo,1])/(1e-15);
      endif;
      call monit(p,y,tim,iter,prnum);  /* Add this line to observe each iteration */
      if rtol<ftol;
      call monit(p,y,tim,iter,prnum);
      RETP(p,y,iter,tim);
      endif;
      if (iter==maxit);
      call monit(p,y,tim,iter,prnum);
      "Maximum number of iterations exceeded";
      RETP(p,y,iter,tim);
      endif;
      if (tim .ge maxsec);
      call monit(p,y,tim,iter,prnum);
      "Maximum number of seconds exceeded";
      RETP(p,y,iter,tim);
      endif;
      iter=iter+1;
      pbar=(sumc(p)-p[ihi,.]')/ndim;
      pr=(1.+alp)*pbar-alp*p[ihi,.]';
      ypr=fct(pr);
      if ypr <=y[ilo,1];
     prr=gam*pr+(1.-gam)*pbar;
     yprr=fct(prr);
     if yprr < y[ilo,1];
    p[ihi,.]=prr';
    y[ihi,1]=yprr;
     else;
    p[ihi,.]=pr';
    y[ihi,1]=ypr;
     endif;
      elseif ypr >= y[inhi,1];
     if ypr < y[ihi,1];
    p[ihi,.]=pr';
    y[ihi,1]=ypr;
     endif;
/*prr=bet*p[ihi,.]'+(1.-gam)*pbar; this is what I was given -- it seems fucked up, gam should be bet*/
     prr=bet*p[ihi,.]'+(1.-bet)*pbar;
     yprr=fct(prr);
     if yprr < y[ihi,1];
    p[ihi,.]=prr';
    y[ihi,1]=yprr;
     else;
    p=.5*(p+p[ilo,.]);
    i=1;
    do while i<=npts;
	 if i==ilo;
	  goto waydone;
	 endif;
       y[i,1]=fct(p[i,.]');
	  waydone:
       i=i+1;
    endo;
     endif;
      else;
     p[ihi,.]=pr';
     y[ihi,1]=ypr;
      endif;
      goto begy;

ENDP;

PROC (0) = monit(p,y,tim,iter,prnum);
     screen on;
     format /ro 9,7;
     if (iter/prnum == round(iter/prnum));
        "iteration: ";; iter; "hours elapsed: ";; tim/3600; ?;
        format /ro 5,6;
        "Value of function at current simplex: ";; y'; ?;
        "current simplex (transposed): ";; p'; ?;
	output off; output on;
     endif;
     format /ro 12,5;

ENDP;

/************************************************************************
Economics       is entirely responsible for the information
provided above. Please direct any comments to Alan G. Isaac at:
          E-Mail Address: aisaac@american.edu
          Phone Number:   (202) 885-3785
*/

